import java.util.Random;

public class Alien implements Comparable<Alien> {

	private int numHeads;
	private String name;
	
	public Alien(int n, String name) {
		this.numHeads = n;
		this.name = name;
	}
	
	public String getName() {
		return name;
		
	}
	
	public int getNumHeads() {
		return numHeads;
	}
	
	public int compareTo(Alien other) {
		String myReversedName = reverseString(name);
		String otherGuyReversedName = reverseString(other.name);
		return myReversedName.compareTo(otherGuyReversedName);	
	}
	
	public static String reverseString(String s) {
		String answer = "";
		for (int i = s.length() - 1; i >= 0; i--) {
			answer += s.charAt(i);
		}
		return answer;
	}
	
	public String toString() {
		return name + ":" + numHeads;
	}
}
